const transformHook = (rw) => {
    // Get properties from rw
    const { theme = {}, pages } = rw

    // Get the breakpoints
    const { breakpoints } = theme

    // Set properties in our template data
    rw.setProps({
        component: rw.component,
        node: rw.node,
        page: rw.page,
        project: rw.project,
        
        // Create a string representation of the ordered breakpoint names array
        strBreakpointNames: JSON.stringify(breakpoints.names),

        // Create a string representation of the breakpoint screens dictionary
        strBreakpointScreens: JSON.stringify(breakpoints.screens),

        // Create a string representation of an array of page titles
        strPages: JSON.stringify(pages.map(page => page.title))
    })
}

exports.transformHook = transformHook;